//
//  MCHostedServer.h
//  MCHosting
//
//  Created by Thomas Bartelmess on 10-08-30.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


@class MCObjectPool, MCIPAddress;
@class MCPGDatabase, MCPGServer, MCPPGConnectionInfo;

#import <MCHosting/MCHostingNode.h>

@interface MCHostedServer : NSObject<MCGetDatabaseConnectionSettingsInformation> {
	
	MCHostingNode * hostingNode;
	MCObjectPool *objectContextPool;

	MCPGServer * pgServer;
	MCPGDatabase *database;
	
	NSString * cloudAccount;	
	NSString *userTable;
	NSString *usernameColumn;
	NSString *passwordColumn;
		
	BOOL waitingForConnectionSettings;
	NSDictionary * connectionSettings;
	
	NSUInteger dbInfoRequestRetryCount;
    NSInteger infoRequestErrorCode;
}

@property (nonatomic, retain) MCHostingNode * hostingNode;
@property (nonatomic, retain) MCObjectPool *objectContextPool;

@property (nonatomic, retain) MCPGServer * pgServer;

@property (nonatomic, copy) NSString *cloudAccount;
@property (nonatomic, copy) NSString *userTable;
@property (nonatomic, copy) NSString *usernameColumn;
@property (nonatomic, copy) NSString *passwordColumn;

@property (nonatomic, readonly) NSString * serverUUID;

@property (retain) MCPGDatabase *database;

@property (nonatomic, readwrite) BOOL waitingForConnectionSettings;
@property (nonatomic, retain) NSDictionary * connectionSettings;

@property (nonatomic, readwrite) NSUInteger dbInfoRequestRetryCount;
@property (nonatomic, readwrite) NSInteger infoRequestErrorCode;

// Queries the connection info server to get the details. Blocks until the info is received.
- (id)initWithCloudAccount:(NSString *)cloudAccount withNode:(MCHostingNode *)aHostingNode;
- (id)initWithConnectionSettings:(NSDictionary *)aConnectionSettings;

// Expects connection settings to be valid and thus does not query connection info server
- (id)initWithCloudAccount:(NSString *)accountID connectionSettings:(NSDictionary *)someSettings node:(MCHostingNode *)aHostingNode;

- (MCPPGConnectionInfo *)pgConnectionInfo;

- (Class)pgServerClass;

- (BOOL)isDatabaseConnected;

// this is supposed to be a MCSAuthorizationResultCode, but that is forward looking...
- (NSInteger)authenticateUsername:(NSString *)uName password:(NSString *)pass;

@end
